// Log.cpp: implementation of the CLog class.
//
//////////////////////////////////////////////////////////////////////

#include "pch.h"
#include "Log.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLog::CLog()
{
	m_fLogIntoStdOut  = false;
	m_fLogIntoStdErr  = false;
	m_fLogIntoFileOut = false;
}

CLog::~CLog()
{
	m_file.Close();
}

//////////////////////////////////////////////////////////////////////
// Methods
//////////////////////////////////////////////////////////////////////

bool CLog::Open(LPCTSTR szLogFileName) {
	if (!m_file.Open( szLogFileName, GENERIC_WRITE, OPEN_ALWAYS ))
		return (false);
	return (m_file.SeekToEnd());
}

char	szOemBuf[MAX_PATH];

CLog& CLog::operator <<(const tstring& s) {
	char*		szOemData = NULL;
	char*		szPtr = NULL;
	int		iLen;

	if (m_fLogIntoFileOut)
		m_file.WriteStringAsOem( s.c_str() );

	if (m_fLogIntoStdOut) {
		iLen = s.length();
		if (iLen >= MAX_PATH) {
			szOemData = new char[iLen+1];
			CharToOem( s.c_str(), szOemData );
			szPtr = szOemData;
		}
		else {
			CharToOem( s.c_str(), szOemBuf );
			szPtr = szOemBuf;
		}
		cout << szPtr;
	}
	if (m_fLogIntoStdErr) {
		if (szPtr == NULL) {
			iLen = s.length();
			if (iLen >= MAX_PATH) {
				szOemData = new char[iLen+1];
				CharToOem( s.c_str(), szOemData );
				szPtr = szOemData;
			}
			else {
				CharToOem( s.c_str(), szOemBuf );
				szPtr = szOemBuf;
			}
		}
		cerr << szPtr;
	}

	if (szOemData != NULL)
		delete [] szOemData;

	return (*this);
}

CLog& CLog::operator <<(LPCTSTR szData) {
	char*	szOemData = NULL;
	int		iLen;
	char*	szPtr = NULL;

    if (m_fLogIntoFileOut) {
		m_file.WriteStringAsOem( szData );
    }

	iLen = lstrlen(szData);

	if (m_fLogIntoStdOut) {		
		if (iLen >= MAX_PATH) {
			szOemData = new char[iLen+1];
			CharToOem( szData, szOemData );
			szPtr = szOemData;
		} else {
			CharToOem( szData, szOemBuf );
			szPtr = szOemBuf;
		}
		cout << szPtr;
	}
	if (m_fLogIntoStdErr) {
		if (szPtr == NULL) {
			if (iLen >= MAX_PATH) {
				szOemData = new char[iLen+1];
				CharToOem( szData, szOemData );
				szPtr = szOemData;
			} else {
				CharToOem( szData, szOemBuf );
				szPtr = szOemBuf;
			}		
		}
		cerr << szPtr;
	}

	if (szOemData != NULL)
		delete [] szOemData;

	return (*this);
}

CLog& CLog::operator <<(int iValue) {
	int	iLen;

	sprintf( szOemBuf, "%i", iValue );
	iLen = strlen( szOemBuf );

	if (m_fLogIntoFileOut)
		m_file.Write( szOemBuf, iLen );

	if (m_fLogIntoStdOut)
		cout << szOemBuf;

	if (m_fLogIntoStdErr)
		cerr << szOemBuf;

	return (*this);
}

CLog& CLog::operator <<(unsigned short usValue) {
	int	iLen;

	sprintf( szOemBuf, "%hu", usValue );
	iLen = strlen( szOemBuf );

	if (m_fLogIntoFileOut)
		m_file.Write( szOemBuf, iLen );

	if (m_fLogIntoStdOut)
		cout << szOemBuf;

	if (m_fLogIntoStdErr)
		cerr << szOemBuf;

	return (*this);
}

CLog& CLog::operator <<(const StdOut& manip) {
	m_fLogIntoStdOut = manip.m_fUse;
	return (*this);
}

CLog& CLog::operator <<(const StdErr& manip) {
	m_fLogIntoStdErr = manip.m_fUse;
	return (*this);
}

CLog& CLog::operator <<(const FileOut& manip) {
	m_fLogIntoFileOut = manip.m_fUse;
	return (*this);
}

CLog& CLog::operator <<(const FlushStd& manip) {
	cout.flush();
	cerr.flush();
	return (*this);
}


CLog& CLog::operator <<(const Push& push) {

	// keep states

	// keep StdOut state
	m_vStates.push_back( m_fLogIntoStdOut );
	// keep StdErr state
	m_vStates.push_back( m_fLogIntoStdErr );
	// keep FileOut state
	m_vStates.push_back( m_fLogIntoFileOut );

	// change one of states

	const	type_info&	ti = typeid(*push.m_pManip);
	if (ti == typeid(StdOut)) {
		m_fLogIntoStdOut = push.m_pManip->m_fUse;
	}
	else if (ti == typeid(StdErr)) {
		m_fLogIntoStdErr = push.m_pManip->m_fUse;
	}
	else if (ti == typeid(FileOut)) {
		m_fLogIntoFileOut = push.m_pManip->m_fUse;
	}

	// free manipulator memory
	delete	push.m_pManip;

	return (*this);
}


CLog& CLog::operator <<(const SetSingle& manip) {

	// keep states

	// keep StdOut state
	m_vStates.push_back( m_fLogIntoStdOut );
	// keep StdErr state
	m_vStates.push_back( m_fLogIntoStdErr );
	// keep FileOut state
	m_vStates.push_back( m_fLogIntoFileOut );

	// reset states
	m_fLogIntoStdOut  = false;
	m_fLogIntoStdErr  = false;
	m_fLogIntoFileOut = false;

	// set one of states

	const	type_info&	ti = typeid(*manip.m_pManip);
	if (ti == typeid(StdOut)) {
		m_fLogIntoStdOut = true;
	}
	else if (ti == typeid(StdErr)) {
		m_fLogIntoStdErr = true;
	}
	else if (ti == typeid(FileOut)) {
		m_fLogIntoFileOut = true;
	}

	// free manipulator memory
	delete	manip.m_pManip;

	return (*this);
}


CLog& CLog::operator <<(const ResetSingle& manip) {

	// keep states

	// keep StdOut state
	m_vStates.push_back( m_fLogIntoStdOut );
	// keep StdErr state
	m_vStates.push_back( m_fLogIntoStdErr );
	// keep FileOut state
	m_vStates.push_back( m_fLogIntoFileOut );

	// set states
	m_fLogIntoStdOut  = true;
	m_fLogIntoStdErr  = true;
	m_fLogIntoFileOut = true;

	// reset one of states

	const	type_info&	ti = typeid(*manip.m_pManip);
	if (ti == typeid(StdOut)) {
		m_fLogIntoStdOut = false;
	}
	else if (ti == typeid(StdErr)) {
		m_fLogIntoStdErr = false;
	}
	else if (ti == typeid(FileOut)) {
		m_fLogIntoFileOut = false;
	}

	// free manipulator memory
	delete	manip.m_pManip;

	return (*this);
}


CLog& CLog::operator <<(const Pop& pop) {

	// skip n-1 states

	for (int i = 0; !m_vStates.empty() && i < (pop.m_nDeep-1); i++) {
		// skip FileOut state
		m_vStates.pop_back();
		// skip StdErr state
		m_vStates.pop_back();
		// skip StdOut state
		m_vStates.pop_back();
	}
	
	// restore states

	if (!m_vStates.empty() && pop.m_nDeep > 0) {
		// restore FileOut state
		m_fLogIntoFileOut = m_vStates.back();
		m_vStates.pop_back();
		// restore StdErr state
		m_fLogIntoStdErr = m_vStates.back();
		m_vStates.pop_back();
		// restore StdOut state
		m_fLogIntoStdOut = m_vStates.back();
		m_vStates.pop_back();
	}

	return (*this);
}
